<?php
function ts_render_taxonomy_submenu( $attributes, $content, $block ) {
    $taxonomy = isset( $attributes['taxonomyName'] ) ? $attributes['taxonomyName'] : 'category';

    $label = isset( $attributes['label'] ) ? $attributes['label'] : '';

    $url = isset( $attributes['url'] ) ? $attributes['url'] : '';

    $half = strlen($taxonomy) / 2;
    if ($half > 0 && substr($taxonomy, 0, $half) === substr($taxonomy, $half)) {
        $taxonomy = substr($taxonomy, 0, $half);
    }
    // Get terms
    $terms = get_terms( [
        'taxonomy'   => $taxonomy,
        'hide_empty' => true,
    ]);


    // $output  = '<div className="block-editor-block-list__block wp-block taxonomy-submenu wp-block-navigation-item has-child wp-block-navigation-submenu">';
    $output  = '<li class="wp-block-navigation-item has-child open-on-hover-click taxonomy-submenu wp-block-navigation-submenu">';
    // Parent <li> like core/navigation-submenu
    $output  .= '<a class="wp-block-navigation-item__content" href="'. $url .'">';
    $output .= '<span class="wp-block-navigation-item__label"> '. esc_html( ucfirst( !empty($label) ? $label : $taxonomy ) ) . '</span>';
    $output .= '</a>';
    $output .= '<button class="wp-block-navigation__submenu-icon wp-block-navigation-submenu__toggle">
                    <svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" viewBox="0 0 12 12" fill="none" aria-hidden="true" focusable="false"><path d="M1.50002 4L6.00002 8L10.5 4" stroke-width="1.5"></path></svg>
                </button>';
    $output .= '<ul class="wp-block-navigation__submenu-container has-text-color has-contrast-color has-background has-base-background-color taxonomy-submenu wp-block-navigation-submenu">';

    if ( is_wp_error( $terms ) || empty( $terms ) ) { 
        $output .= '';
    } else {
      foreach ( $terms as $term ) {
        $output .= '<li class=" wp-block-navigation-item wp-block-navigation-link">';
        $output .= '<a class="wp-block-navigation-item__content" href="' . esc_url( get_term_link( $term ) ) . '">';
        $output .= '<span class="wp-block-navigation-item__label">' . esc_html( $term->name ) . "</span>";
        $output .= '</a>';
        $output .= '</li>';
      }
    }

    $output .= '</ul>';
    $output .= '</li>';
    // $output .= '</div>';

    return $output;
}

register_block_type( __DIR__, [
    'render_callback' => 'ts_render_taxonomy_submenu',
] );
