<?php
/**
 * Plugin Name: Taxonomy Submenu
 * Description: A custom Navigation Submenu block that dynamically lists WordPress taxonomies (e.g., categories, tags, WooCommerce brands).
 * Version: 1.0.0
 * Author: Your Name
 * Requires at least: 6.1
 * Requires PHP: 7.4
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}

/**
 * Registers the block using the metadata loaded from block.json.
 * Also attaches the render callback from render.php.
 */
function ts_register_taxonomy_submenu_block() {
    $dir = __DIR__;

    // Path to block.json inside src/taxonomy-submenu
    $block_json = $dir;

    // Make sure block.json exists
    if ( ! file_exists( $block_json . '/block.json' ) ) {
        error_log( '[Taxonomy Submenu] block.json not found at ' . $block_json );
        return;
    }

    // Load render callback
    require_once $block_json . '/src/render.php';

    register_block_type(
        $block_json,
        [
            'render_callback' => 'ts_render_taxonomy_submenu',
        ]
    );
}
add_action( 'init', 'ts_register_taxonomy_submenu_block' );

/**
 * Example: safely check if WooCommerce is active
 */
function ts_is_woocommerce_active() {
    return class_exists( 'WooCommerce' );
}
