<?php
function ts_render_taxonomy_submenu( $attributes, $content, $block ) {
    $taxonomy = isset( $attributes['taxonomyName'] ) ? $attributes['taxonomyName'] : 'category';

    $label = isset( $attributes['label'] ) ? $attributes['label'] : '';

    $url = isset( $attributes['url'] ) ? $attributes['url'] : '';

    $heading_color       = ! empty( $attributes['headingColor'] ) ? $attributes['headingColor'] : '';
    $submenu_bg          = ! empty( $attributes['submenuBg'] ) ? $attributes['submenuBg'] : '';
    $submenu_text_color  = ! empty( $attributes['submenuTextColor'] ) ? $attributes['submenuTextColor'] : '';
    $submenu_padding_obj = ! empty( $attributes['submenuPadding'] ) && is_array( $attributes['submenuPadding'] ) ? $attributes['submenuPadding'] : null;
    $submenu_width  = ! empty( $attributes['submenuWidth'] ) ? $attributes['submenuWidth'] : '';
    $submenu_border = isset( $attributes['submenuBorder'] ) && is_array( $attributes['submenuBorder'] ) ? $attributes['submenuBorder'] : [];
    $submenu_border_radius = ! empty( $attributes['submenuBorderRadius'] ) ? $attributes['submenuBorderRadius'] : '';
    $submenu_box_shadow  = ! empty( $attributes['submenuBoxShadow'] ) ? $attributes['submenuBoxShadow'] : '';
    $item_bg             = ! empty( $attributes['submenuItemBg'] ) ? $attributes['submenuItemBg'] : '';
    $item_hover_bg       = ! empty( $attributes['submenuItemHoverBg'] ) ? $attributes['submenuItemHoverBg'] : '';
    $submenu_item_padding = ! empty( $attributes['submenuItemPadding'] ) && is_array( $attributes['submenuItemPadding'] ) ? $attributes['submenuItemPadding'] : null;
    $submenu_item_text_align = ! empty( $attributes['submenuItemTextAlign'] ) ? $attributes['submenuItemTextAlign'] : '';
    $submenu_item_border = isset( $attributes['submenuItemBorder'] ) && is_array( $attributes['submenuItemBorder'] ) ? $attributes['submenuItemBorder'] : [];
    $submenu_item_border_radius = ! empty( $attributes['submenuItemRadius'] ) ? $attributes['submenuItemRadius'] : '';
    $submenu_item_hover_text_color = ! empty( $attributes['submenuItemHoverTextColor'] ) ? $attributes['submenuItemHoverTextColor'] : '';

    $padding_css = '';
    if ( $submenu_padding_obj ) {
        $top    = isset( $submenu_padding_obj['top'] )    ? $submenu_padding_obj['top']    : '0';
        $right  = isset( $submenu_padding_obj['right'] )  ? $submenu_padding_obj['right']  : '0';
        $bottom = isset( $submenu_padding_obj['bottom'] ) ? $submenu_padding_obj['bottom'] : '0';
        $left   = isset( $submenu_padding_obj['left'] )   ? $submenu_padding_obj['left']   : '0';
        $padding_css = trim( sprintf( '%s %s %s %s', $top, $right, $bottom, $left ) );
    }

    $item_padding_css = '';
    if ( $submenu_item_padding ) {
        $item_padding_css = sprintf(
            '%s %s %s %s',
            $submenu_item_padding['top'] ?? '0',
            $submenu_item_padding['right'] ?? '0',
            $submenu_item_padding['bottom'] ?? '0',
            $submenu_item_padding['left'] ?? '0'
        );
    }

    $half = strlen($taxonomy) / 2;
    if ($half > 0 && substr($taxonomy, 0, $half) === substr($taxonomy, $half)) {
        $taxonomy = substr($taxonomy, 0, $half);
    }
    // Get terms
    $terms = get_terms( [
        'taxonomy'   => $taxonomy,
        'hide_empty' => true,
    ]);

    // Unique id to scope hover CSS
    $instance_id = wp_unique_id( 'ts-submenu-' );

    $wrapper_attrs = get_block_wrapper_attributes( [
        'id'    => $instance_id,
        'class' => 'taxonomy-submenu wp-block-navigation-item has-child open-on-hover-click wp-block-navigation-submenu'
    ] );

    // Inline styles
    $heading_style_attr = $heading_color ? ' style="color:' . esc_attr( $heading_color ) . ';"' : '';

    $submenu_border_css = function( $side ) use ( $submenu_border ) {
        if ( empty( $submenu_border[ $side ] ) || ! is_array( $submenu_border[ $side ] ) ) return [];
        $b = $submenu_border[ $side ];
        $map = [
            'top'    => ['border-top-style','border-top-width','border-top-color'],
            'right'  => ['border-right-style','border-right-width','border-right-color'],
            'bottom' => ['border-bottom-style','border-bottom-width','border-bottom-color'],
            'left'   => ['border-left-style','border-left-width','border-left-color'],
        ];
        $out = [];
        if ( ! empty( $b['style'] ) ) $out[] = $map[$side][0] . ':' . esc_attr( $b['style'] );
        if ( ! empty( $b['width'] ) ) $out[] = $map[$side][1] . ':' . esc_attr( $b['width'] );
        if ( ! empty( $b['color'] ) ) $out[] = $map[$side][2] . ':' . esc_attr( $b['color'] );
        return $out;
    };

    $submenu_styles = array_merge(
        $submenu_border_css('top'),
        $submenu_border_css('right'),
        $submenu_border_css('bottom'),
        $submenu_border_css('left')
    );

    $submenu_border_base_width = isset( $submenu_border['width'] ) ? $submenu_border['width'] : '';
    $submenu_border_base_style = isset( $submenu_border['style'] ) ? $submenu_border['style'] : '';
    $submenu_border_base_color = isset( $submenu_border['color'] ) ? $submenu_border['color'] : '';

    if ( $submenu_border_base_style === 'none' ) {
        $submenu_styles[] = 'border:none';
    } else {
        if ( $submenu_border_base_style ) $submenu_styles[] = 'border-style:' . esc_attr( $submenu_border_base_style );
        if ( $submenu_border_base_width ) $submenu_styles[] = 'border-width:' . esc_attr( $submenu_border_base_width );
        if ( $submenu_border_base_color ) $submenu_styles[] = 'border-color:' . esc_attr( $submenu_border_base_color );
    }

    if ( $submenu_bg )         { $submenu_styles[] = 'background:' . esc_attr( $submenu_bg ); }
    if ( $submenu_text_color ) { $submenu_styles[] = 'color:' . esc_attr( $submenu_text_color ); }
    if ( $padding_css )        { $submenu_styles[] = 'padding:' . esc_attr( $padding_css ); }
    if ( $submenu_width )        { $submenu_styles[] = 'width:' . esc_attr( $submenu_width ) . ' !important'; }
    if ( $submenu_border_radius )        { $submenu_styles[] = 'border-radius:' . esc_attr( $submenu_border_radius ); }
    if ( $submenu_box_shadow )        { $submenu_styles[] = 'box-shadow:' . esc_attr( $submenu_box_shadow ); }
    $submenu_style_attr = $submenu_styles ? ' style="' . esc_attr( implode( ';', $submenu_styles ) ) . ';"' : '';

    $side_css = function( $side ) use ( $submenu_item_border ) {
        if ( empty( $submenu_item_border[ $side ] ) || ! is_array( $submenu_item_border[ $side ] ) ) return [];
        $b = $submenu_item_border[ $side ];
        $map = [
            'top'    => ['border-top-style','border-top-width','border-top-color'],
            'right'  => ['border-right-style','border-right-width','border-right-color'],
            'bottom' => ['border-bottom-style','border-bottom-width','border-bottom-color'],
            'left'   => ['border-left-style','border-left-width','border-left-color'],
        ];
        $out = [];
        if ( ! empty( $b['style'] ) ) $out[] = $map[$side][0] . ':' . esc_attr( $b['style'] );
        if ( ! empty( $b['width'] ) ) $out[] = $map[$side][1] . ':' . esc_attr( $b['width'] );
        if ( ! empty( $b['color'] ) ) $out[] = $map[$side][2] . ':' . esc_attr( $b['color'] );
        return $out;
    };

    $item_styles = array_merge(
        $side_css('top'),
        $side_css('right'),
        $side_css('bottom'),
        $side_css('left')
    );

    $submenu_item_border_base_width = isset( $submenu_item_border['width'] ) ? $submenu_item_border['width'] : '';
    $submenu_item_border_base_style = isset( $submenu_item_border['style'] ) ? $submenu_item_border['style'] : '';
    $submenu_item_border_base_color = isset( $submenu_item_border['color'] ) ? $submenu_item_border['color'] : '';

    if ( $submenu_item_border_base_style === 'none' ) {
        $item_styles[] = 'border:none';
    } else {
        if ( $submenu_item_border_base_style ) $item_styles[] = 'border-style:' . esc_attr( $submenu_item_border_base_style );
        if ( $submenu_item_border_base_width ) $item_styles[] = 'border-width:' . esc_attr( $submenu_item_border_base_width );
        if ( $submenu_item_border_base_color ) $item_styles[] = 'border-color:' . esc_attr( $submenu_item_border_base_color );
    }

    if ( $item_padding_css )              $item_styles[] = 'padding:' . esc_attr( $item_padding_css );
    if ( $submenu_item_border_radius ) { $item_styles[] = 'border-radius:' . esc_attr( $submenu_item_border_radius ); }

    $item_style_attr = $item_styles ? ' style="' . esc_attr( implode( ';', $item_styles ) ) . ';"' : '';

    $text_styles = [];

    if ( $submenu_item_text_align )       $text_styles[] = 'justify-content:' . esc_attr( $submenu_item_text_align );

    $text_style_attr = $text_styles ? ' style="' . esc_attr( implode( ';', $text_styles ) ) . ';"' : '';

    // $output  = '<div className="block-editor-block-list__block wp-block taxonomy-submenu wp-block-navigation-item has-child wp-block-navigation-submenu">';
    $output  = '<li' .$wrapper_attrs. '>';
    // Parent <li> like core/navigation-submenu
    $output  .= '<a class="wp-block-navigation-item__content" href="'. esc_url($url) .'">';
    $output .= '<span class="wp-block-navigation-item__label"> '. esc_html( ucfirst( !empty($label) ? $label : $taxonomy ) ) . '</span>';
    $output .= '</a>';
    $output .= '<button class="wp-block-navigation__submenu-icon wp-block-navigation-submenu__toggle">
                    <svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" viewBox="0 0 12 12" fill="none" aria-hidden="true" focusable="false"><path d="M1.50002 4L6.00002 8L10.5 4" stroke-width="1.5"></path></svg>
                </button>';
    $output .= '<ul class="wp-block-navigation__submenu-container"' .$submenu_style_attr. '>';

    if ( is_wp_error( $terms ) || empty( $terms ) ) { 
        $output .= '';
    } else {
      foreach ( $terms as $term ) {
        $output .= '<li class=" wp-block-navigation-item wp-block-navigation-link"' . $item_style_attr . '>';
        $output .= '<a class="wp-block-navigation-item__content" href="' . esc_url( get_term_link( $term ) ) . '" ' . $text_style_attr . '>';
        $output .= '<span class="wp-block-navigation-item__label">' . esc_html( $term->name ) . "</span>";
        $output .= '</a>';
        $output .= '</li>';
      }
    }

    $output .= '</ul>';

    if ( $item_hover_bg ) {
        $output .= '<style>#' . esc_attr( $instance_id ) . ' .wp-block-navigation__submenu-container > li:hover{background:' . esc_attr( $item_hover_bg ) . ' !important;}</style>';
    }

    $output .= '</li>';
    // $output .= '</div>';

    return $output;
}

register_block_type( __DIR__, [
    'render_callback' => 'ts_render_taxonomy_submenu',
] );
