jQuery(document).ready(function($) {

    function initAddonControls(container) {

        // Add new addon
        $('#wbap-add-addon').on('click', function(e) {
            e.preventDefault();
            var newAddon = `
            <div class="wbap-addon-row">
                <input type="text" name="" placeholder="Addon Name" />
                <button type="button" class="button wbap-remove-addon">Remove</button>
                <div class="wbap-addon-options"></div>
                <button type="button" class="button wbap-add-option">Add Option</button>
            </div>`;
            container.append(newAddon);
            updateFieldNames(container);
        });

        // Add new option
        container.on('click', '.wbap-add-option', function(e) {
            e.preventDefault();
            var addonRow = $(this).closest('.wbap-addon-row');
            var optionsContainer = addonRow.find('.wbap-addon-options');
            var newOption = `
                <div class="wbap-option-row">
                    <input type="text" name="" placeholder="Option Name" />
                    <input type="number" step="0.01" name="" placeholder="Price" />
                    <button type="button" class="button wbap-remove-option">Remove</button>
                </div>`;
            optionsContainer.append(newOption);
            updateFieldNames(container);
        });

        // Remove addon
        container.on('click', '.wbap-remove-addon', function(e) {
            e.preventDefault();
            $(this).closest('.wbap-addon-row').remove();
            updateFieldNames(container);
        });

        // Remove option
        container.on('click', '.wbap-remove-option', function(e) {
            e.preventDefault();
            $(this).closest('.wbap-option-row').remove();
            updateFieldNames(container);
        });
    }

    function updateFieldNames(container) {
        container.find('.wbap-addon-row').each(function(a_idx) {
            $(this).find('input[name]').each(function() {
                var input = $(this);
                var optionRow = input.closest('.wbap-option-row');
                if (optionRow.length) {
                    var o_idx = optionRow.index();
                    if (input.attr('placeholder') === 'Option Name') {
                        input.attr('name', `wbap_addons[${a_idx}][options][${o_idx}][label]`);
                    } else {
                        input.attr('name', `wbap_addons[${a_idx}][options][${o_idx}][price]`);
                    }
                } else {
                    input.attr('name', `wbap_addons[${a_idx}][addon_label]`);
                }
            });
        });
    }

    initAddonControls($('#wbap-addons-container'));
});

// Settings Page
jQuery(document).ready(function($){

    // Add new addon
    $(document).on('click', '.wbap-add-addon', function(){
        var container = $(this).closest('.wbap-brand-container');
        var termId = container.data('term-id');
        var addonIndex = container.find('.wbap-addon-row').length;

        var addonHtml = `
        <div class="wbap-addon-row">
            <input type="text" name="wbap_brands_addons[${termId}][${addonIndex}][addon_label]" placeholder="Addon Label" />
            <button type="button" class="button wbap-remove-addon">Remove Addon</button>
            <div class="wbap-addon-options"></div>
            <button type="button" class="button wbap-add-option" data-addon-index="${addonIndex}" data-term-id="${termId}">Add Option</button>
        </div>
        `;
        container.find('.wbap-addons-container').append(addonHtml);
    });

    // Remove addon
    $(document).on('click', '.wbap-remove-addon', function(){
        $(this).closest('.wbap-addon-row').remove();
    });

    // Add option
    $(document).on('click', '.wbap-add-option', function(){
        var addonRow = $(this).closest('.wbap-addon-row');
        var termId = $(this).data('term-id');
        var addonIndex = $(this).data('addon-index');
        var optionIndex = addonRow.find('.wbap-option-row').length;

        var optionHtml = `
        <div class="wbap-option-row">
            <input type="text" name="wbap_brands_addons[${termId}][${addonIndex}][options][${optionIndex}][label]" placeholder="Option Label" />
            <input type="number" step="0.01" name="wbap_brands_addons[${termId}][${addonIndex}][options][${optionIndex}][price]" placeholder="Price" />
            <button type="button" class="button wbap-remove-option">Remove Option</button>
        </div>
        `;
        addonRow.find('.wbap-addon-options').append(optionHtml);
    });

    // Remove option
    $(document).on('click', '.wbap-remove-option', function(){
        $(this).closest('.wbap-option-row').remove();
    });

});

