<?php
// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) exit;

// Add a top-level menu for Brand Addons
add_action('admin_menu', function() {
    add_menu_page(
        __('Brand Addons', 'wbap'),
        __('Brand Addons', 'wbap'),
        'manage_options',
        'wbap-brand-addons',
        'wbap_settings_page',
        'dashicons-admin-generic',
        56
    );
});

function wbap_settings_page() {
    if (isset($_POST['wbap_save_addons_nonce']) && wp_verify_nonce($_POST['wbap_save_addons_nonce'], 'wbap_save_addons')) {

        // Get all brands
        $brands = get_terms([
            'taxonomy' => 'product_brand',
            'hide_empty' => false,
        ]);

        foreach ($brands as $brand) {
            $term_id = $brand->term_id;
            $addons = $_POST['wbap_brands_addons'][$term_id] ?? [];

            $clean_addons = wbap_clean_addons($addons);

            if (!empty($clean_addons)) {
                update_term_meta($term_id, 'wbap_addons', $clean_addons);
            } else {
                delete_term_meta($term_id, 'wbap_addons'); // Remove all addons if none
            }
        }

        echo '<div class="updated"><p>' . __('Brand addons saved successfully!', 'wbap') . '</p></div>';
    }

    // Load all brands and their addons
    $brands = get_terms([
        'taxonomy' => 'product_brand',
        'hide_empty' => false,
    ]);

    ?>
    <div class="wrap">
        <h1>Brand Addons</h1>
        <form method="post">
            <?php wp_nonce_field('wbap_save_addons', 'wbap_save_addons_nonce'); ?>
            <?php foreach($brands as $brand): 
                $addons = get_term_meta($brand->term_id, 'wbap_addons', true) ?: [];
            ?>
                <div class="wbap-brand-container" data-term-id="<?php echo esc_attr($brand->term_id); ?>">
                    <h2><?php echo esc_html($brand->name); ?></h2>
                    <div class="wbap-addons-container">
                        <?php foreach($addons as $addon_index => $addon): ?>
                            <div class="wbap-addon-row">
                                <input type="text" name="wbap_brands_addons[<?php echo $brand->term_id; ?>][<?php echo $addon_index; ?>][addon_label]" value="<?php echo esc_attr($addon['addon_label']); ?>" placeholder="Addon Label" />
                                <button type="button" class="button wbap-remove-addon">Remove Addon</button>
                                <div class="wbap-addon-options">
                                    <?php if (!empty($addon['options'])): ?>
                                        <?php foreach($addon['options'] as $option_index => $option): ?>
                                            <div class="wbap-option-row">
                                                <input type="text" name="wbap_brands_addons[<?php echo $brand->term_id; ?>][<?php echo $addon_index; ?>][options][<?php echo $option_index; ?>][label]" value="<?php echo esc_attr($option['label']); ?>" placeholder="Option Label" />
                                                <input type="number" step="0.01" name="wbap_brands_addons[<?php echo $brand->term_id; ?>][<?php echo $addon_index; ?>][options][<?php echo $option_index; ?>][price]" value="<?php echo esc_attr($option['price']); ?>" placeholder="Price" />
                                                <button type="button" class="button wbap-remove-option">Remove Option</button>
                                            </div>
                                        <?php endforeach; ?>
                                    <?php endif; ?>
                                </div>
                                <button type="button" class="button wbap-add-option" data-addon-index="<?php echo $addon_index; ?>" data-term-id="<?php echo $brand->term_id; ?>">Add Option</button>
                            </div>
                        <?php endforeach; ?>
                    </div>
                    <button type="button" class="button wbap-add-addon">Add Addon</button>
                </div>
                <hr>
            <?php endforeach; ?>
            <?php submit_button('Save All Addons'); ?>
        </form>
    </div>
    <?php
}

function wbap_clean_addons($addons) {
    $clean = [];
    if (!is_array($addons)) return $clean;

    foreach ($addons as $addon) {
        if (empty($addon['addon_label'])) continue;

        $clean_addon = [];
        $clean_addon['addon_label'] = sanitize_text_field($addon['addon_label']);
        $clean_addon['options'] = [];

        if (!empty($addon['options']) && is_array($addon['options'])) {
            foreach ($addon['options'] as $option) {
                if (empty($option['label'])) continue;

                $clean_addon['options'][] = [
                    'label' => sanitize_text_field($option['label']),
                    'price' => floatval($option['price'] ?? 0),
                ];
            }
        }

        $clean[] = $clean_addon;
    }

    return $clean;
}
